<?php
/**
 * Plugin Name: MyPersonas Integration
 * Description: Integrates MyPersonas tracking script with WordPress user data
 * Version: 1.0
 * Author: Your Name
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class MyPersonasIntegration {
    
    public function __construct() {
        add_action('wp_head', array($this, 'add_mypersonas_script'));
    }
    
    public function add_mypersonas_script() {
        ?>
        <script type="text/javascript">
        (function(){
            var s=document.createElement('script');
            s.src="https://cdn.mypersonas.ai/static/js/mypersonas.js";
            s.setAttribute("data-integration-id","<INTEGRATION_ID>");
            s.setAttribute("data-product","authenticated-website");
            s.setAttribute("data-region","us");
            s.defer=true;
            document.head.appendChild(s);
        })();
        </script>
        
        <?php if (is_user_logged_in()): 
            $current_user = wp_get_current_user();
            $user_data = $this->get_user_data($current_user);
            if ($user_data): // Only output if we have valid user data
        ?>
        <script type="text/javascript">
          window.MYP_HOST_DETAILS = window.MYP_HOST_DETAILS || {};
          window.MYP_HOST_DETAILS.user = {
            providerUserId: "<?php echo esc_js($user_data['id']); ?>",
            firstName: "<?php echo esc_js($user_data['first_name']); ?>",
            lastName: "<?php echo esc_js($user_data['last_name']); ?>",
            email: "<?php echo esc_js($user_data['email']); ?>",
            provider: "wordpress"
          };
        </script>
        <?php endif; endif; ?>
        <?php
    }
    
    private function get_user_data($user) {
        // Ensure we have valid user data
        if (!$user || !$user->ID) {
            return null;
        }
        
        return array(
            'id' => $user->ID,
            'first_name' => !empty($user->first_name) ? $user->first_name : $user->display_name,
            'last_name' => !empty($user->last_name) ? $user->last_name : '',
            'email' => $user->user_email
        );
    }
}

// Initialize the plugin
new MyPersonasIntegration();
?>
